﻿# -*- coding: utf-8 -*-
import gtk
import pango
from datetime import datetime
import inspect

import gui

class c:
	buff = gtk.TextBuffer()
	tag_table = buff.get_tag_table()
	tag={} # data structure (array)

	def init(self):
		gui.w().set("logText", [])
	
	#LOGS COLORS
	#Information
		self.tag["I"] = gtk.TextTag()
		self.tag["I"].set_property('background', "#FFFFFF")
		self.tag_table.add(self.tag["I"])
	#Warning
		self.tag["W"] = gtk.TextTag()
		self.tag["W"].set_property('background', "#FFDE8C") #yelow for warnings
		self.tag_table.add(self.tag["W"])
	#Error
		self.tag["E"] = gtk.TextTag()
		self.tag["E"].set_property('background', "#CF310D") #red background for error style log
		self.tag_table.add(self.tag["E"])
		
		self.info("Programos žurnalizavimo posistemė sėkmingai įkrauta", f(), l())
# ...........................................................................................................................

	def info(self, msg, file=None, line=None): # public
		self._add(msg, "info", file, line)
# ...........................................................................................................................

	def warn(self, msg, file=None, line=None): # public
		self._add(msg, "warning", file, line)
# ...........................................................................................................................

	def error(self, msg, file=None, line=None): #public
		self._add(msg, "error", file, line)
# ...........................................................................................................................
	
	def logPrint(self, win=None):# public
		textview = gui.w().get("dLog").get_widget('textview1')
#		textview = win.get_widget('textview2')
		textview.set_buffer(self.buff)
		textview.modify_font(pango.FontDescription("Courier New 8"))
# ...........................................................................................................................

	def logClear(self): # public
		self.buff.delete(self.buff.get_start_iter(), self.buff.get_end_iter())
		gui.w().set("logText", [])
# ...........................................................................................................................

	def logFilter(self, logType): # public
		log = gui.w().get("logText")
		#clear buffer
		self.buff.delete(self.buff.get_start_iter(), self.buff.get_end_iter())
		for i in range(len(log)): #logai
			for j in range(len(logType)):	#tipai
				if log[i][0].upper() == logType[j]:
					msg = "%s %s (%s@%s)\n" % ( log[i][1], log[i][2], log[i][3], log[i][4])
					self.buff.insert(self.buff.get_start_iter(), msg)
					self.buff.apply_tag(self.tag[logType[j]], self.buff.get_start_iter(), self.buff.get_iter_at_offset(len(msg)))
# ...........................................................................................................................
	# ################    P R I V A T E     F U N C T I O N S ################
	def _add(self, msg, style, file, line): #private
		#Add logs to array
		log_time = datetime.now().strftime("%H:%M:%S")
		gui.w().get("logText").append([style[0].upper(), log_time, msg, line, file])
		msg = "%s %s (%s@%s)\n" % (log_time, msg, line, file)
		self.buff.insert(self.buff.get_start_iter(), msg)
		self.buff.apply_tag(self.tag[style[0].upper()], self.buff.get_start_iter(), self.buff.get_iter_at_offset(len(msg)))
# +-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-+-=-

#global functions for easy trace
def l():
	return inspect.currentframe().f_back.f_lineno
def f():
	pathArray = inspect.currentframe().f_back.f_code.co_filename.split("\\")
	return pathArray[len(pathArray)-1]

class info:		#class for showing up various error messages

	def question(self, text, secText = None):#public
		md = gtk.MessageDialog(None, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_QUESTION, gtk.BUTTONS_CLOSE, text)
		if secText: md.format_secondary_text(secText)
		md.set_position(gtk.WIN_POS_CENTER_ALWAYS)
#		md.set_skip_taskbar_hint(True)
		md.run()
		md.destroy()

	def info(self, text, secText = None):#public
		md = gtk.MessageDialog(None, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_INFO, gtk.BUTTONS_OK, text)
		if secText: md.format_secondary_text(secText)
		md.set_position(gtk.WIN_POS_CENTER_ALWAYS)
#		md.set_skip_taskbar_hint(True)
		md.run()
		md.destroy()

	def warn(self, text, secText = None):#public
		md = gtk.MessageDialog(None, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_WARNING, gtk.BUTTONS_CLOSE, text)
		if secText: md.format_secondary_text(secText)
		md.set_position(gtk.WIN_POS_CENTER_ALWAYS)
#		md.set_skip_taskbar_hint(True)
		md.run()
		md.destroy()

	def error(self, text, secText = None):#public
		md = gtk.MessageDialog(None, gtk.DIALOG_DESTROY_WITH_PARENT, gtk.MESSAGE_ERROR, gtk.BUTTONS_OK, text)
		if secText: md.format_secondary_text(secText)
		md.set_position(gtk.WIN_POS_CENTER_ALWAYS)
#		md.set_skip_taskbar_hint(True)
		md.run()
		md.destroy()