﻿# -*- coding: utf-8 -*-
import gtk, gobject	#GUI creation
import string, threading, time

# windows stuff
from ctypes import windll
import win32file, win32api



#import dbi, odbc	#database stuff
#import os			#operating system (domain and username)
#import socket		#openning a connection to specified host and port

import hDialogSettings
import robocopy

import gui			#windows manager
import log 			#logging and messages package
import cfg			#ini configuration files reader


'''
G ('KINGSTON', 875770417, 255, 6, 'FAT32')		Kopijoms
H ('STORE N GO', 766032775, 255, 6, 'FAT32')	šaltinis
'''
class c:

	DRIVE_TYPES = ["Unknown", "No Root Directory", "Removable Disk", "Local Disk", "Network Drive",	"Compact Disc",	"RAM Disk"	]
	
	combo1Model = gtk.ListStore(str, str)
	combo2Model = gtk.ListStore(str)
	
	conf = cfg.c("conf.ini")

	def init(self):	#main window initialization
		
		gui.w().set("windowMain", gui.c().openWindow("windowMain"))
		gui.w().get("windowMain").get_widget('windowMain').set_visible(True)
		color = gtk.gdk.color_parse('#ffffff')
		gui.w().get("windowMain").get_widget('windowMain').modify_bg(gtk.STATE_NORMAL, color)
		
		diskList = self.getDisks()
		self.prepareCombobox()
		self.fillCombobox(diskList)
		self.findSourceDisk(diskList)
		self.findDestinationDisk(diskList)

#...........................................................................................................................

	def onWindowMainDestroy(self): # close application window
		gtk.main_quit()
# ...........................................................................................................................

	def getDisks(self):
		drives = []
		bitmask = windll.kernel32.GetLogicalDrives()
		for letter in string.uppercase:
			if bitmask & 1:
				drives.append(letter)
			bitmask >>= 1
		return drives

	def prepareCombobox(self):
		sourceWidget = gui.w().get("windowMain").get_widget('combobox1')
		sourceWidget.set_model(self.combo1Model)
		#drive
		cell = gtk.CellRendererText()
		sourceWidget.pack_start(cell, True)
		sourceWidget.add_attribute(cell, 'text', 0)
		#type
		cell = gtk.CellRendererText()
		sourceWidget.pack_start(cell, True)
		sourceWidget.add_attribute(cell, 'text', 1)
		
		destWidget = gui.w().get("windowMain").get_widget('combobox2')
		#destination path
		destWidget.set_model(self.combo2Model)
		destWidget.pack_start(cell, True)
		destWidget.add_attribute(cell, 'text', 0)
		
	def fillCombobox(self, list):
		
		self.combo1Model.clear()
		self.combo2Model.clear()
		destinationFolder = self.conf.getValue("Global", "destFolder")
		
		for item in list:
			type = self.DRIVE_TYPES[win32file.GetDriveType ("%s:"%item)]
			self.combo1Model.append(["%s:\\"%item, "(%s)"%type])
			self.combo2Model.append(["%s:\\%s"%(item, destinationFolder)])
		
	def findSourceDisk(self, list):
		sourceDiskSerial = self.conf.getValue("Global", "sourceDisk")
		diskFound = False;
		for item in list:
			try:
				driveInfo = win32api.GetVolumeInformation("%s:\\"%item)
				if str(driveInfo[1]) == sourceDiskSerial:
					gui.w().get("windowMain").get_widget('combobox1').set_active(list.index(item))
					diskFound =True
					break
			except: pass
		if not diskFound:
			log.info().error("Source disk not found", "Check if disk is inserted and correct serial number provided in configuration")
			#gui.w().get("windowMain").get_widget('button1').set_sensitive(False)
	
	def findDestinationDisk(self, list):
		destinationDiskSerial = self.conf.getValue("Global", "destDisk")
		diskFound = False;
		for item in list:
			try:
				driveInfo = win32api.GetVolumeInformation("%s:\\"%item)
				if str(driveInfo[1]) == destinationDiskSerial:
					gui.w().get("windowMain").get_widget('combobox2').set_active(list.index(item))
					diskFound =True
					break
			except: pass
		if not diskFound:
			log.info().error("Destination disk not found", "Check if disk is inserted and correct serial number provided in configuration")
			#gui.w().get("windowMain").get_widget('button1').set_sensitive(False)
		
		#path = "C:\\"
		#info = win32api.GetVolumeInformation(path)
		#print( "disk serial number = %d" % info[1] )
		
	def refreshDisksList(self):
#		log.c().info("Refreshing disks list", log.f(), log.l())
		#gui.w().get("windowMain").get_widget('button1').set_sensitive(True)
		diskList = self.getDisks()
		self.fillCombobox(diskList)
		self.findSourceDisk(diskList)
		self.findDestinationDisk(diskList)
	
	def openSettingsDialog(self):
#		log.c().info("Opening 'Settings' configuration dialog", log.f(), log.l())
		gui.w().set("dialogSettings", gui.c().openDialog("dialogSettings"))
		hDialogSettings.c().init() #initiate data in window
	
	def openAboutDialog(self):
		gui.w().set("dialogAbout", gui.c().openDialog("dialogAbout"))
	
	def beginMirror(self):
		win = gui.w().get("windowMain")
	
		backAction = self.conf.getValue("Robocopy", "action")
		backOption = self.conf.getValue("Robocopy", "option")
		
		source = win.get_widget("combobox1").get_active_text()
		dest = win.get_widget("combobox2").get_active_text()
		
		#check if any data is entered
		if not source or not dest:
			log.info().error("Source and destination can\'t be empty")

		gui.w().set("winProgress", gui.c().openDialog("winProgress"))
		doBackup(source, dest, backAction, backOption).start()#create thread with these details
		
		while gtk.events_pending(): gtk.main_iteration() #update gui if there is any changes to do
		while True: #Wait some time, till 1 thread left (_MainThread)
			threadCount = threading.active_count()
			if  threadCount > 1:
				gui.w().get("winProgress").get_widget('progressbar1').pulse()
				gui.w().get("winProgress").get_widget('label13').set_text("Searching....   please wait")
				while gtk.events_pending(): gtk.main_iteration() #update gui if there is any changes to do
			else:
				break
			time.sleep(0.5)
		
		gui.c().closeWin("winProgress")
		log.info().info("Task finished", "Didn't found anyone prettier ;)")
		
# ###########################################################################################################################

#						http://stefaanlippens.net/redirect_python_print

class doBackup(threading.Thread): # do mirroring in separate thread
	rob = robocopy.PyRobocopier()
	
	def __init__ (self, source, dest, action, backOption=None):
		super(doBackup, self).__init__()
		threading.Thread.__init__ (self)
		self.rob.set_source_dest_action(source, dest, action)
		if "P" in backOption : self.rob.set_purge(True)
		if "F" in backOption : self.rob.set_force(True)
		if "R" in backOption : self.rob.set_reverse(2)
		if "C" in backOption : self.rob.set_maketarget(True)
		if "M" in backOption : self.rob.set_modtime(True)

# ...........................................................................................................................

	def run(self): #worker
		self.rob.do_work() #

#		while not gui.w().get("killAllThreads"):
#			gobject.idle_add(self._updateClock)
#			time.sleep(0.5)
#		#print "Thread '%s' has just exited"%self.__class__.__name__