﻿# -*- coding: utf-8 -*-
import gtk, subprocess
from ctypes import windll
import win32file, win32api
import string

#import bz2, base64		#password coding
#from datetime import datetime
#import time
import hWindowMain
import log 		#logs and messages package
import gui		#windows manager
import cfg		#configs manager

class c:
	conf = cfg.c("conf.ini")
	DRIVE_TYPES = ["Unknown", "No Root Directory", "Removable Disk", "Local Disk", "Network Drive",	"Compact Disc",	"RAM Disk"	]
											#	level,	Image
	#settingsQuickStatusList = gtk.ListStore(	str,	gtk.gdk.Pixbuf ) #quick status

	def init(self):
		win = gui.w().get("dialogSettings")
		#source and target
		try:
			win.get_widget("entry1").set_text(self.conf.getValue("Global", "sourceDisk"))
			win.get_widget("entry2").set_text(self.conf.getValue("Global", "destDisk"))
			win.get_widget("entry3").set_text(self.conf.getValue("Global", "destFolder"))
		except: pass
		
		#robocopy action
		action = self.conf.getValue("Robocopy", "action")
			#pythonic switch statement
		try:
			radioItem = {
				'U': "radiobutton1",
				'S': "radiobutton2",
				'D': "radiobutton3"
			}[action]
			
			win.get_widget(radioItem).set_active(True)
		except: pass
		
		#robocopy options
		option = self.conf.getValue("Robocopy", "option")
		try:
			if "P" in option : win.get_widget("checkbutton1").set_active(True)
			if "F" in option : win.get_widget("checkbutton2").set_active(True)
			if "R" in option : win.get_widget("checkbutton3").set_active(True)
			if "C" in option : win.get_widget("checkbutton4").set_active(True)
			if "M" in option : win.get_widget("checkbutton5").set_active(True)
		except: pass

	def listDisks(self, widget, event):
		if event.button == 1:
			if gui.w().get("windowDisksList")!=None:
				gui.w().get("windowDisksList").get_widget("windowDisksList").show()
			else:
				gui.w().set("windowDisksList", gui.c().openWindow("windowDisksList"))
			win = gui.w().get("windowDisksList")
			size = win.get_widget("windowDisksList").get_size()
			pos = win.get_widget("windowDisksList").get_position()
			mw = pos[0]+(size[0]/2)-20
			mh = pos[1]+(size[1]/2)-20
			win.get_widget("windowDisksList").move(mw, mh)
			win.get_widget("windowDisksList").set_visible(True)
			gui.w().set("target", widget)
			self.prepareList(win, widget)

	
	def prepareList(self, win, widget):
		listView = win.get_widget("treeview1")
		if listView.get_model() == None:
			model = gtk.ListStore( gtk.gdk.Pixbuf, str, str, str ) #icon, letter, type, serialNum
			listView.set_model(model)

			#First column's cells
			cell = gtk.CellRendererPixbuf()
			col = gtk.TreeViewColumn("Icon", cell)
			col.add_attribute(cell, "pixbuf", 0)
			listView.append_column(col)
			#Second column's cell
			cell = gtk.CellRendererText()
			col = gtk.TreeViewColumn("Letter")
			col.pack_start(cell, True)
			col.set_attributes(cell,text=1)
			listView.append_column(col)
			#third column's cell
			cell = gtk.CellRendererText()
			col = gtk.TreeViewColumn("Type")
			col.pack_start(cell, True)
			col.set_attributes(cell,text=2)
			listView.append_column(col)
			#fourth column's cell
			cell = gtk.CellRendererText()
			col = gtk.TreeViewColumn("Code")
			col.pack_start(cell, True)
			col.set_attributes(cell,text=3)
			listView.append_column(col)
			self._getDisks(model)
			listView.connect("cursor-changed", lambda w: self.fillDiskCode( listView ))
	
	#transfer code from list to caller widget
	def fillDiskCode(self, widget):
		destWidget = gui.w().get("target")
		model, iter = widget.get_selection().get_selected()
		#index = model.get_path(iter)[0]
		code = model.get_value(iter, 3)
		try:
			destWidget.set_text(code)
			widget.get_parent().hide()
			destWidget.grab_focus()
		except:log.info().warn("Try again", "Selected drive does not have serial number")

	def destFolderHelp(self):
		msg = '''%Y% - Year
					%M% - Month
					%D% - Day
					%h% - hour
					%m% - minute
					%s% - second'''
		log.info().info("SOON WILL BE Available variables:", msg)
	
	#if last slash (\) is missing, append it automaticaly. Also check if all variables are allowed
	def checkDestFolder(self, widget):
		path = widget.get_text()
		if "%" in path:
			pathWithVars = path
			for var in ["%Y%","%M%","%D%","%h%","%m%","%s%"]:
				pathWithVars = pathWithVars.replace(var, "")
			if "%" in pathWithVars:
				log.info().warn("Unacceptable variable detected", "Please click questionmark icon in right side of field to find out allowed variables")
				widget.grab_focus()
				return
			
		if path[-1:] != "\\":
			path = path+"\\"
		
		widget.set_text(path)
		
	def closeSettings(self): # dialog cancel (do not save)
		gui.c().closeWin("dialogSettings")
	
	def saveSettings(self):
		win = win = gui.w().get("dialogSettings")
		sourceDiskVal = win.get_widget("entry1").get_text()
		destDiskVal = win.get_widget("entry2").get_text()
		destFolderVal = win.get_widget("entry3").get_text()
		
		action = {
			win.get_widget("radiobutton1").get_active():"U",
			win.get_widget("radiobutton2").get_active():"S",
			win.get_widget("radiobutton3").get_active():"D"
		}[True]
		option=""
		
		if win.get_widget("checkbutton1").get_active(): option+="P"
		if win.get_widget("checkbutton2").get_active(): option+="F"
		if win.get_widget("checkbutton3").get_active(): option+="R"
		if win.get_widget("checkbutton4").get_active(): option+="C"
		if win.get_widget("checkbutton5").get_active(): option+="M"
		
		if(sourceDiskVal == destDiskVal):
			return log.info().warn("Destination disk must be different from source")
		
		cat = "Global"
		if not self.conf.hasSection(cat):
			self.conf.setSection(cat)
		self.conf.setValue(cat, "sourceDisk", sourceDiskVal)
		self.conf.setValue(cat, "destDisk", destDiskVal)
		self.conf.setValue(cat, "destFolder", destFolderVal)
		
		cat = "Robocopy"
		if not self.conf.hasSection(cat):
			self.conf.setSection(cat)
		self.conf.setValue(cat, "action", action)
		self.conf.setValue(cat, "option", option)
		
		hWindowMain.c().refreshDisksList()
		self.closeSettings()
	
	def presetDefault(self):
		win = gui.w().get("dialogSettings")
		#source and target
		win.get_widget("entry1").set_text("766032775")
		win.get_widget("entry2").set_text("875770417")
		win.get_widget("entry3").set_text("backup\\")
		
		win.get_widget("radiobutton2").set_active(True)
		
		win.get_widget("checkbutton1").set_active(True)
		win.get_widget("checkbutton2").set_active(False)
		win.get_widget("checkbutton3").set_active(False)
		win.get_widget("checkbutton4").set_active(False)
		win.get_widget("checkbutton5").set_active(True)
		
		log.info().question("Default settings are hard-coded specialy for friend", "Please check do settings meat reality")

#-------------------------------------------------------------------------------------------------
	def windowDisksListClose(self, event):
		if event.keyval == 65307: #escape
			gui.c().closeWin("windowDisksList")
	
	def _getDisks(self, model):
		model.clear()
		bitmask = windll.kernel32.GetLogicalDrives()
		for letter in string.uppercase:
			if bitmask & 1:
				type = win32file.GetDriveType ("%s:"%letter)
				try:		icon = gtk.gdk.pixbuf_new_from_file("GUI/drives/%s.png"%type)
				except:	icon = gtk.gdk.pixbuf_new_from_file("GUI/question16.png")
				typeString = self.DRIVE_TYPES[type]
				try: driveInfo = win32api.GetVolumeInformation("%s:\\"%letter)
				except:	driveInfo = [None, None]
				model.append([icon, letter, typeString, driveInfo[1]])
			bitmask >>= 1
#		return drives

##################################################################################################