﻿# -*- coding: utf-8 -*-
import ConfigParser
import os

class c:

	name = None;
	handler = None
	config = ConfigParser.RawConfigParser() #config object
	
	def __init__(self, conf):
		self.name = conf
		self.handler = self.open(conf)

# sections
	def setSection(self, section): # section
		if self.hasSection(section):
			self.delSection(section)
		self.handler.add_section(section)
		self._save()

	def hasSection(self, section): # public
		return self.handler.has_section(section)
	
	def delSection(self, section): # public
		if self.hasSection(section):
			self.handler.remove_section(section)
		self._save()
		
# values
	def hasValue(self, section, name):
		return self.handler.has_option(section, name)
	
	def getValue(self, section, name, type=None): # public
		if self.hasValue(section, name):
			if not type:
				return self.handler.get(section, name)
			elif(type=='i'):
				return self.handler.getint(section, name)
			elif(type=='f'):
				return self.handler.getfloat(section, name)
			elif(type=='b'):
				return self.handler.getboolean(section, name)
			else:
				raise Exception("TypeError", "Uknown variable type. Allowed (i, f, b)")

	def setValue(self, section, name, value): # public
		if self.hasValue(section, name):
			self.delValue(section, name)
		self.handler.set(section, name, value)
		self._save()

	def delValue(self, section, name):
		if self.hasValue(section, name):
			self.handler.remove_option(section, name)
		self._save()
		
	def _save(self):#private
		with open(self.name, 'wb') as configfile:
			self.config.write(configfile)

# ##########################################################
	def open(self, fileName):#public
		fullPath = os.path.join(os.getcwd(), fileName)
		if os.path.exists(fullPath):
			self.config.read(fileName)
			return self.config	
		else:
			self.new_file(fileName)
			self.config.read(fileName)
			return self.config
#			raise Exception('File not found', fullPath)

	def new_file(self, fileName):#public
		fullPath = os.path.join(os.getcwd(), fileName)
		if not os.path.exists(fullPath):
			#create empty file
			FILE = open(fileName,"w")
			FILE.close()
			return 1

#config.add_section('Section1')
#config.set('Section1', 'int', '15')
#config.set('Section1', 'bool', 'true')
#config.set('Section1', 'float', '3.1415')
#config.set('Section1', 'baz', 'fun')
#config.set('Section1', 'bar', 'Python')
#config.set('Section1', 'foo', '%(bar)s is %(baz)s!')

#float = config.getfloat('Section1', 'float')
#int = config.getint('Section1', 'int')
#if config.getboolean('Section1', 'bool'):
#	print config.get('Section1', 'foo')
